#ifndef _TABLE_H
#define _TABLE_H

#include <QtGui>

#include "mode1/erdiagram/Arrow.h"
#include "mode1/erdiagram/AttributesRect.h"

class NameRect;
class PrimaryKeysRect;
class AttributesRect;

class Table : public QGraphicsRectItem
{
//	Q_OBJECT

	public:
		enum GuideRect {LeftTop=0, Top, RightTop, Left, Right, LeftBottom, Bottom, RightBottom};

	public:
		Table(QPointF point, QString length, QGraphicsItem * parent = 0);
		//Table(QPointF& point, NameRect nameRect, PrimaryKeysRect primaryRect, AttributesRect attributesRect, 
		//	QGraphicsItem * parent = 0);
		virtual ~Table();

	public:
		void AddArrow(Arrow* arrow);
		void SetPosition(int state);
		void SetRect(double gap);
		void ReSize();
		
		//void MakeGuideRect();
		//void SetGuideRectVisible(bool state);

	protected:
		//void keyPressEvent ( QKeyEvent * event );
		//void mouseReleaseEvent ( QGraphicsSceneMouseEvent * event );
		//void mousePressEvent ( QGraphicsSceneMouseEvent * event );
		void mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * event );
		QVariant itemChange(GraphicsItemChange change, const QVariant &value);

	public:
//		QList<QGraphicsRectItem> GetGuideRect() const;
		QRectF GetRect() const;
		NameRect* GetNameRect() const;
		PrimaryKeysRect* GetPrimaryRect() const;
		AttributesRect* GetAttributesRect() const;
		QList<Arrow*> GetArrows() const;

	private:
		QRectF rect;
		NameRect* nameRect;
		PrimaryKeysRect* primaryRect;
		AttributesRect* attributesRect;
		QList<Arrow*> arrows;				
		//QList<QGraphicsRectItem*> guideRect;
};

inline QList<Arrow*> Table::GetArrows() const
{
	return this->arrows;
}

inline QRectF Table::GetRect() const
{
	return this->rect;
}

inline NameRect* Table::GetNameRect() const
{
	return this->nameRect;
}

inline PrimaryKeysRect* Table::GetPrimaryRect() const
{
	return this->primaryRect;
}

inline AttributesRect* Table::GetAttributesRect() const
{
	return this->attributesRect;
}

#endif //_TABLE_H
